<?php
// Model AjukanShift
namespace App\Models;

use App\Models\User;
use App\Models\Shift;
use App\Models\Departemen;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class AjukanShift extends Model
{
    use HasFactory;

    protected $table = 'ajukan_shifts';

    protected $fillable = [
        'departemen_id',
        'shift_lama_id',
        'shift_baru_id',
        'tanggal_mulai',
        'tanggal_selesai',
        // 'jenis',
        'requested_by',
        'approved_by',
        'alasan',
        'status',
        'catatan_admin'
    ];

    protected $casts = [
        'tanggal_mulai' => 'date',
        'tanggal_selesai' => 'date',
    ];

    public function pemohon()
    {
        return $this->belongsTo(User::class, 'requested_by');
    }

    public function approver()
    {
        return $this->belongsTo(User::class, 'approved_by');
    }

    public function shiftLama()
    {
        return $this->belongsTo(Shift::class, 'shift_lama_id');
    }

    public function shiftBaru()
    {
        return $this->belongsTo(Shift::class, 'shift_baru_id');
    }

    public function departemen()
    {
        return $this->belongsTo(Departemen::class);
    }
}
